// Game clock object by WIP [super-modified by Keith Link]
// This is a function that will create a game clock object.
// Just use the function clock.getTime() and it will
// return an object with seconds, minutes and hours
// Note: You must start the clock before it will give
// the correct time

function Clock()
{
	this.started = 0;
	this.seconds = 0;
	this.minutes = 0;
	this.hours = 0;
}

// Example: var GameClock = new Clock();

Clock.prototype.start = function()
{
	this.started = GetTime();
}

// Example: GameClock.start();

Clock.prototype.getTime = function()
{
	var current = (GetTime() + originaltime) - this.started;

	this.seconds = Math.floor((current)/1000) % 60;
	if (this.seconds < 10) this.seconds = "0" + this.seconds;
	
	this.minutes = Math.floor((current)/1000/60) % 60;
	if (this.minutes < 10) this.minutes = "0" + this.minutes;
	
	this.hours = Math.floor((current)/1000/60/60) % 60;
	if (this.hours < 10) this.hours = "0" + this.hours;
	
	return this.hours + ":" + this.minutes + ":" + this.seconds;
}

// Example:
// font.drawText(10, 10, clock.getTime());
//
// Every time you want to start keeping track of time, 
// start the clock. If you are loading a game, you should
// load the time into the clock object. That way, it can keep
// correct time with a loaded game.